 ; Ŀ
 ;   Next - go to the next drawing listed in a text file.                  
 ;   Copyright 1995, 2001, 2005, 2009 by Rocket Software Ltd.              
 ;                                                                         
 ; 

 ; Ŀ
 ;   Dredge - get a list of all drawing files in the directory containing  
 ;   the current drawing, add the path to each one.                        
 ;   Currently takes no arguments.                                         
 ;   Returns a list of filenames with paths.                               
 ; 
 (DEFUN DREDGE (/ pref fils num fnam nulis dwgnam stop sub)
  (setq pref (getvar "dwgprefix"))
  (setq fils (vl-directory-files pref "*.dwg" 1))
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
  (setq fils (acad_strlsort fils))
  (setq num 0)
  (while (and fils (setq fnam (nth num fils)))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
  (setq nulis (reverse nulis))
 ; Ŀ
 ;   Cut the deck so that the drawing after the current one is on top.     
 ; 
  (setq dwgnam (strcat pref (getvar "dwgname")))
  (while (and (null stop) (setq sub (car nulis)))
         (setq nulis (cdr (append nulis (list sub))))
         (if (equal sub dwgnam)
             (setq stop t)))
 nulis)
 ; Ŀ
 ;   Dredge end.                                                           
 ; 

 ; Ŀ
 ;   Nail - create the names only text file.                               
 ;   Takes the file name as its sole argument, returns nothing, but is     
 ;   quietly creative.                                                     
 ; 
 (DEFUN NAIL (fnam / flist num fo tt)
  (setq flist (dredge))
  (setq num (length flist))
  (if (setq fo (open fnam "w"))
      (progn
           (while (setq tt (car flist))
                  (setq flist (cdr flist))
                  (write-line tt fo))
           (prompt (strcat "\n" (itoa num) " drawing file"
                           (if (= num 1) "" "s") " found.\n"))
           (close fo)))
 (princ))
 ; Ŀ
 ;   Nail end.                                                             
 ; 

 ; Ŀ
 ;   Nofi: read the first line from the filename list file, rewrite the    
 ;   file without the first line, return the first line or nil.            
 ;   If the file is empty it is deleted.                                   
 ;   Takes one argument, the file name.                                    
 ; 
 (DEFUN NOFI (fnam / fn nam1 namm liss num)
  (setq fn (open fnam "r"))
  (if (setq nam1 (read-line fn))
      (progn
           (while (setq namm (read-line fn))
                  (setq liss (cons namm liss)))
           (close fn)
           (setq liss (reverse liss))
           (setq num (length liss))
           (setq fn (open fnam "w"))
           (while (setq namm (car liss))
                  (setq liss (cdr liss))
                  (write-line namm fn))
           (close fn)
           (prompt (strcat "\n" (itoa num) " drawing file"
                           (if (= num 1) "" "s") " left.\n")))
     (progn
           (close fn)
           (command "shell" (strcat "del " fnam))))
 nam1)
 ; Ŀ
 ;   Nofi end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Next - open a drawing, optionally save the last one.       
 ;   Arguments: Sava, "Y" or "N" - save changes if asked.                  
 ;   Returns T if need to restart/remake the file, nil otherwise.          
 ; 
 (DEFUN NEXT (sava / nam1 len goon restac)
  (setvar "cmdecho" 1)
  (setvar "sdi" 1)
  (if (/= (getvar "sdi") 1)
      (prompt "*Caution: SDI is not set - you are opening multiple drawings."))
 ; Ŀ
 ;   Make the name file name, use the current drawing path.                
 ; 
  (setq fnam (strcat (getvar "dwgprefix") "names.nxt"))
 ; Ŀ
 ;   If can't find the partially eaten name file then make a new one.      
 ; 
  (if (null (findfile fnam)) (nail fnam))
 ; Ŀ
 ;   Call Nofi to return the first line in the file and delete it from     
 ;   the file.                                                             
 ; 
  (setq nam1 (nofi fnam))
 ; Ŀ
 ;   If the filename stored in Nam1 has the extension ".dwg", remove it.   
 ; 
  (if (and nam1
           (= (strcase (substr nam1 (- (setq len (strlen nam1)) 3))) ".DWG"))
      (setq nam1 (substr nam1 1 (- len 4))))
 ; Ŀ
 ;   If Nam1 contains a drawing filename and the drawing exists, open it.  
 ; 
  (cond ((and nam1 (findfile (strcat nam1 ".dwg")))
         (command "open")
         (if (> (rem (getvar "dbmod") 32) 0)
             (command sava)   ; Y, save or N, don't, only if asked
             (princ))
         (command nam1))
 ; Ŀ
 ;   If the drawing doesn't exist, point this out.                         
 ; 
        (nam1
         (write-line (strcat "File " nam1 " is unavailable.  Try again.")))
 ; Ŀ
 ;   If there are no files left, offer to go round again.                  
 ; 
        (T
         (initget 0 "Yes No")
         (setq goon (getkword "All files accessed.  Restart? <Y>: "))
         (if (or (null goon) (= goon "Yes"))
             (setq restac T))))
 restac)
 ; Ŀ
 ;   Next end.                                                             
 ; 

 ; Ŀ
 ;   Next - go to the next file, save changes (if any).                    
 ; 
 (DEFUN C:NEXT ()
  (if (next "n") (c:next))
 (princ))

 ; Ŀ
 ;   Nex - go to the next file, discard changes.                           
 ; 
 (DEFUN C:NEX ()
  (if (next "y") (c:nex))
 (princ))

(princ)
